/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProject;
import org.sonarlint.eclipse.ui.internal.SonarLintProjectDecorator;

public class UnbindProjectsCommand
extends AbstractHandler {
    public Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        final ArrayList<IProject> selectedProjects = new ArrayList<IProject>();
        List elems = selection.toList();
        for (Object elem : elems) {
            IProject proj;
            if (elem instanceof IProject) {
                selectedProjects.add((IProject)elem);
                continue;
            }
            if (!(elem instanceof IAdaptable) || (proj = (IProject)((IAdaptable)elem).getAdapter(IProject.class)) == null) continue;
            selectedProjects.add(proj);
        }
        Job job = new Job("Unbind projects"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Unbind projects", selectedProjects.size());
                for (IProject p : selectedProjects) {
                    SonarLintProject sonarLintProject = SonarLintProject.getInstance((IResource)p);
                    sonarLintProject.setServerId(null);
                    sonarLintProject.setModuleKey(null);
                    sonarLintProject.save();
                    monitor.worked(1);
                }
                IBaseLabelProvider labelProvider = PlatformUI.getWorkbench().getDecoratorManager().getBaseLabelProvider("org.sonarlint.eclipse.ui.sonarlintDecorator");
                if (labelProvider != null) {
                    ((SonarLintProjectDecorator)labelProvider).fireChange(selectedProjects.toArray(new IProject[0]));
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return null;
    }
}

